rem @echo off

:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::
:: Synchronise FTP Server with Aegis Monita Command Server
::
:: This batch file syncs the following directories:
::    command/out -> ftp/out
::    ftp/in      -> command/in
::
:: The batch file also deletes any unwanted files in these directories, preserving only files of
:: the forms "out/123456.cmd", "in/123456.ok" and "in/123456.fail", and only as long as they have the 
:: correct internal format.
::
:: This batch file should be called every 5 or 10 minutes.
::
:: All executions and file deletions are recorded in a log file.
::
:: This batch file requires a small C utility program: moncheck.exe.  This program checks the validity
:: of an Aegis Monita file, and can compare the internal timestamps of two valid files.
::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

:: Configurable parameters for the Command Server directories
set INPATH=\\192.168.4.207\ftp\in
set OUTPATH=\\192.168.4.207\ftp\out

:: Configurable log file
set LOGFILE=logfiles\logger.log

:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

rem @echo off
rem The weird DOS syntax means that both the subroutines and the main batch file must fall through to :end.
rem Remember that "errorlevel N" actually means "errorlevel >= N".

echo ================================================================= >> %LOGFILE%
date /t >> %LOGFILE%
time /t >> %LOGFILE%
@SET CYGWIN=ntsec

:: Sync the directories, deleting any junk files found

for %%f in (%OUTPATH%\*) do call :checkfile1 "%%f"

echo Rsync local\out to ftp\out >> %LOGFILE%
c:\cygwin\bin\rsync.exe -az --password-file=c:\cygwin\secret --delete /cygdrive/c/ftp/out remotebackup@192.168.4.6::logger >> %LOGFILE%

echo Rsync ftp\in to local\in >> %LOGFILE%
c:\cygwin\bin\rsync.exe -az --password-file=c:\cygwin\secret --remove-source-files remotebackup@192.168.4.6::logger/in /cygdrive/c/ftp  >> %LOGFILE%

for %%f in (%INPATH%\*) do call :checkfile1 "%%f"

:: Compare the .cmd and .ok/.fail files, processing the responses

for %%f in (%INPATH%\* %OUTPATH%\*) do call :checkfile2 %%~nf

goto mainend

rem ==============================================================================================================
rem === Delete all files that do not match the templates: in\123456.ok, in\123456.fail or out\123456.cmd,
rem === or that do not have valid internal formats
rem === parameter #1 = full pathname with quotes of file to check (e.g. "\\12.34.56.78\ftp\out\123456.cmd")

:checkfile1
echo Validity-Checking %1  >> %LOGFILE%

rem ---- Check to see if the filename is of the correct form.  Delete any that are not.

if not exist %1 goto lab0
moncheck -q %1
if not errorlevel 4 goto lab00
echo - Invalid filename format - deleting %1  >> %LOGFILE%
del %1

:lab00
goto end

rem ==============================================================================================================
rem === Compare and .ok, .fail and .cmd files that are present, and only leave the most recent.
rem === parameter #1 = base filename of file to check (e.g. 123456)

:checkfile2
echo Response-Checking %1  >> %LOGFILE%

set OKFILE=%INPATH%\%1.ok
set FAILFILE=%INPATH%\%1.fail
set CMDFILE=%OUTPATH%\%1.cmd

rem ---- If both OK and FAIL file exist, delete the older.

if not exist %OKFILE% goto lab4
if not exist %FAILFILE% goto lab4
moncheck -q %OKFILE% %FAILFILE%
if errorlevel 3 goto lab4
if errorlevel 2 goto lab5
echo - OK and FAIL files both present - deleting %FAILFILE%  >> %LOGFILE%
del %FAILFILE%
goto lab4
:lab5
echo - OK and FAIL files both present - deleting %OKFILE%  >> %LOGFILE%
del %OKFILE%

:lab4
set RSPFILE=%FAILFILE%
if exist %OKFILE% set RSPFILE=%OKFILE%

rem ---- If both CMD and OK/FAIL files exist, delete the older.  If they have the same time, delete CMD.
if not exist %CMDFILE% goto lab6
if not exist %RSPFILE% goto lab6
moncheck -q %CMDFILE% %RSPFILE%
if errorlevel 3 goto lab6
if errorlevel 2 goto lab7
if not errorlevel 1 goto lab7
echo - New CMD file found - deleting %RSPFILE%  >> %LOGFILE%
del %RSPFILE%
goto lab6
:lab7
echo - New OK/FAIL file found - deleting %CMDFILE%  >> %LOGFILE%
del %CMDFILE%

:lab6
goto end

rem ==============================================================================================================

rem ==== any shutdown processing here...
:mainend

:end
